#ifndef EXPORTCONTROLLER_H
#define EXPORTCONTROLLER_H

#include <QObject>

class QWidget;

class TagTreeControl;

class ReaderEntry;
class AntennaEntry;
class TagEntry;

class CExportDialog;


class ExportController : public QObject
{
    Q_OBJECT
public:
    typedef enum {
        TagTypeExportFlag           = 0x00000001,
        ReadCountExportFlag         = 0x00000002,
        TimeStampExportFlag         = 0x00000004,
		ReaderNameExportFlag	    = 0x00010000,
		ReaderSerialExportFlag	    = 0x00020000,
        ReaderAntennaExportFlag	    = 0x00040000,
    } ExportFlags;

    ExportController (TagTreeControl* tagTreeControl, QWidget* window,  QObject* parent = 0);
    ~ExportController();

public slots:
    void exportRequest ( );
    void quickExportRequest ( );

public:
    QString lastError();

    int exportTagListToFile(QString fileName, ulong exportFlags, QString delimiter = QString(";"));

private:
    QStringList exportTag(ulong exportFlags, ReaderEntry* readerEntry, AntennaEntry* antennaEntry, TagEntry *tagEntry);

private:
    QString	    	m_lastError;
    QWidget*	    m_window;
    CExportDialog*  m_exportDialog;
    TagTreeControl* m_tagTreeControl;
};

#endif // EXPORTCONTROLLER_H
